/*
 * Decompiled with CFR 0.152.
 */
package netknack.light;

import java.io.PrintStream;
import netknack.light.BlendedWindowGame;
import netknack.light.EnumExperimentType;
import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.EnumQueuePolicy;
import netknack.light.Finals;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.NetKnackUI;
import netknack.light.WindowGame;

public class Experiment {
    public NetKnackUI nkUI;
    public Logger logger;
    EnumExperimentType experimentType;
    int blendNum = 20;
    int gameID;
    int pregameRounds;
    int duration;
    GameParams gameParams;
    PrintStream logpst;

    public Experiment(NetKnackUI netKnackUI, String[] args) {
        this.nkUI = netKnackUI;
        this.nkUI.logLine("Creating experiment with NetKnack v" + Finals.version);
        this.gameParams = new GameParams();
        this.experimentType = EnumExperimentType.parseExperimentType(args[0]);
        this.blendNum = Integer.parseInt(args[1]);
        this.gameParams.gameID = Integer.parseInt(args[2]);
        this.gameParams.duration = Integer.parseInt(args[3]);
        this.gameParams.pregameRounds = Integer.parseInt(args[4]);
        this.gameParams.capacity = Integer.parseInt(args[5]);
        this.gameParams.variableCapacity = Integer.parseInt(args[6]);
        this.gameParams.penalty = EnumFlowPenalty.parseFlowPenalty(args[7]);
        this.gameParams.queuePolicyType = EnumQueuePolicy.parseQueuePolicy(args[8]);
        this.gameParams.nFlows = Integer.parseInt(args[9]);
        this.gameParams.flowPolicyType = EnumFlowController.parseFlowController(args[10]);
        this.gameParams.SetArrays(this.gameParams.nFlows);
        int i = 0;
        while (i < this.gameParams.nFlows - 1) {
            this.gameParams.aArray[i] = Integer.parseInt(args[11]);
            this.gameParams.bArray[i] = Double.parseDouble(args[12]);
            ++i;
        }
        this.gameParams.aArray[this.gameParams.nFlows - 1] = Integer.parseInt(args[13]);
        this.gameParams.bArray[this.gameParams.nFlows - 1] = Double.parseDouble(args[14]);
        this.gameParams.seed = Long.parseLong(args[15]);
        this.logger = new Logger(this.nkUI, this.gameParams);
    }

    public void playOneGame() {
        WindowGame wg = new WindowGame(this.gameParams, this.logger);
        wg.playAllRounds();
        this.logger.logLine(wg.getGameStats().toString());
    }

    public void playOneBlendedGame(int blendNum) {
        BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, this.gameParams);
        bwg.playAllRounds();
        this.logger.logLine(bwg.getGameStats().toString());
    }

    public void playGamesForAllA() {
        int minA = 1;
        int maxA = this.gameParams.capacity;
        int a = minA;
        while (a <= maxA) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a++;
            WindowGame wg = new WindowGame(this.gameParams, this.logger);
            wg.playAllRounds();
            this.logger.logLine(wg.getGameStats().toString());
        }
    }

    public void playBlendedGamesForAllA(int blendNum) {
        int minA = 1;
        int maxA = this.gameParams.capacity;
        int a = minA;
        while (a <= maxA) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a++;
            BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, oneGame);
            bwg.playAllRounds();
            this.logger.logLine(bwg.getGameStats().toString());
        }
    }

    public void playBlendedGamesForAllB(int blendNum) {
        int minB = 50;
        int maxB = 99;
        int i = minB;
        while (i <= maxB) {
            GameParams oneGame = this.gameParams.clone();
            ++this.gameParams.gameID;
            oneGame.gameID = oneGame.gameID;
            Double b = new Double(0.01 * (double)i);
            oneGame.bArray[oneGame.nFlows - 1] = b;
            BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, oneGame);
            bwg.playAllRounds();
            this.logger.logLine(bwg.getGameStats().toString());
            ++i;
        }
    }

    public void execute() {
        this.logger.logLine("Starting experiment ...");
        switch (this.experimentType) {
            case GAME: {
                this.playOneGame();
                break;
            }
            case BGAME: {
                this.playOneBlendedGame(this.blendNum);
                break;
            }
            case BGAME_ALL_A: {
                this.playBlendedGamesForAllA(this.blendNum);
                break;
            }
            case BGAME_ALL_B: {
                this.playBlendedGamesForAllB(this.blendNum);
                break;
            }
            default: {
                System.err.println("Unexpected experiment type: " + this.experimentType.toString());
            }
        }
        this.logger.logLine("Experiment terminated !");
    }
}

