/*
 * Decompiled with CFR 0.152.
 */
package netknack.light;

import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.FlowControlAPI;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.WindowGame;
import netknack.light.flowcontrol.AIMDFlowController;
import netknack.light.flowcontrol.FlowController;
import netknack.light.stats.FlowStats;

public class Flow
implements FlowControlAPI {
    int flowID;
    public Logger logger;
    GameParams gameparams;
    WindowGame windowGame;
    public int initialWindowSize;
    public int windowSize;
    EnumFlowPenalty penalty;
    int a;
    double b;
    public int maxAllowedWindowSize;
    public int requestedPackets;
    public int acceptedPackets;
    public int totalRequestedPackets;
    public int totalAcceptedPackets;
    int numPenalties;
    int numPenaltyRounds;
    EnumFlowController flowPolicyType;
    FlowController flowController;
    int numberOfPenaltyRounds;

    public Flow(int parFlowID, Logger parLogger, GameParams parGameParams, WindowGame parWindowGame, int parInitialWindowSize, EnumFlowController parFlowPolicyType, int parA, double parB, EnumFlowPenalty parPenalty) {
        this.flowID = parFlowID;
        this.gameparams = parGameParams;
        this.logger = parLogger;
        this.windowGame = parWindowGame;
        this.windowSize = parInitialWindowSize;
        this.flowPolicyType = parFlowPolicyType;
        this.a = parA;
        this.b = parB;
        this.penalty = parPenalty;
        switch (this.flowPolicyType) {
            case AIMD: {
                this.flowController = new AIMDFlowController(this, this.a, this.b);
                break;
            }
            default: {
                this.logger.logLineMand("Unexpected flow policy type : " + (Object)((Object)this.flowPolicyType));
                this.logger.logLineMand("Using AIMD be default.");
                this.flowPolicyType = EnumFlowController.AIMD;
                this.flowController = new AIMDFlowController(this, this.a, this.b);
            }
        }
        this.initFlowStats();
    }

    @Override
    public EnumFlowPenalty getPenalty() {
        return this.penalty;
    }

    @Override
    public double getWindowSize() {
        return this.windowSize;
    }

    @Override
    public int getWindowSizeInt() {
        int size = Math.round(this.windowSize);
        return size;
    }

    @Override
    public int getMaxAllowedWindowSize() {
        return this.maxAllowedWindowSize;
    }

    @Override
    public int getAcceptedPackets() {
        return this.acceptedPackets;
    }

    public int getNumPenalties() {
        return this.flowController.numPenalties();
    }

    public int getNumPenaltyRounds() {
        return this.flowController.numPenaltyRounds();
    }

    @Override
    public void setWindowSize(int size) {
        this.windowSize = size;
    }

    public int requestedPackets() {
        this.flowController.beginRound();
        if (this.windowGame.gameOn) {
            this.totalRequestedPackets += this.windowSize;
        }
        return this.windowSize;
    }

    public void acceptedPackets(int parAcceptedPackets) {
        this.acceptedPackets = parAcceptedPackets;
        if (this.windowGame.gameOn) {
            this.totalAcceptedPackets += this.acceptedPackets;
        }
        this.flowController.endRound();
    }

    public int getTotalRequestedPackets() {
        return this.totalRequestedPackets;
    }

    public int getTotalAcceptedPackets() {
        return this.totalAcceptedPackets;
    }

    public void initFlowStats() {
        this.initialWindowSize = this.windowSize;
        this.totalRequestedPackets = 0;
        this.totalAcceptedPackets = 0;
        this.numberOfPenaltyRounds = 0;
    }

    public FlowStats getFlowStats() {
        FlowStats fStats = new FlowStats();
        fStats.blendNum = 1;
        fStats.flowID = this.flowID;
        fStats.initialWindowSize = this.initialWindowSize;
        fStats.a = this.a;
        fStats.b = this.b;
        fStats.totalRequestedPackets = this.totalRequestedPackets;
        fStats.totalAcceptedPackets = this.totalAcceptedPackets;
        return fStats;
    }
}

