/*
 * Decompiled with CFR 0.152.
 */
package netknack.light;

import netknack.light.EnumQueuePolicy;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.QueuePolicyAPI;
import netknack.light.WindowGame;
import netknack.light.queuepolicy.CHOKePlusQueuePolicy;
import netknack.light.queuepolicy.CHOKeQueuePolicy;
import netknack.light.queuepolicy.DropTailQueuePolicy;
import netknack.light.queuepolicy.GreedyPlusQueuePolicy;
import netknack.light.queuepolicy.MaxMinQueuePolicy;
import netknack.light.queuepolicy.PrinceBasicQueuePolicy;
import netknack.light.queuepolicy.PrinceGQueuePolicy;
import netknack.light.queuepolicy.PrinceMQueuePolicy;
import netknack.light.queuepolicy.QueuePolicy;
import netknack.light.queuepolicy.REDQueuePolicy;
import netknack.light.stats.RouterStats;

public class Router
implements QueuePolicyAPI {
    Logger logger;
    WindowGame windowGame;
    GameParams gameparams;
    EnumQueuePolicy queuePolicyType;
    QueuePolicy queuePolicy;
    public int totalRequestedPackets;
    public int totalAcceptedPackets;

    public Router(GameParams parGameParams, Logger parLogger, WindowGame parWindowGame, EnumQueuePolicy parQueuePolicyType) {
        this.gameparams = parGameParams;
        this.logger = parLogger;
        this.windowGame = parWindowGame;
        this.queuePolicyType = parQueuePolicyType;
        switch (this.queuePolicyType) {
            case DROPTAIL: {
                this.queuePolicy = new DropTailQueuePolicy(this);
                break;
            }
            case RED: {
                this.queuePolicy = new REDQueuePolicy(this);
                break;
            }
            case CHOKE: {
                this.queuePolicy = new CHOKeQueuePolicy(this);
                break;
            }
            case CHOKEPLUS: {
                this.queuePolicy = new CHOKePlusQueuePolicy(this);
                break;
            }
            case PRINCEG: {
                this.queuePolicy = new PrinceGQueuePolicy(this);
                break;
            }
            case PRINCER: {
                this.queuePolicy = new PrinceMQueuePolicy(this);
                break;
            }
            case PRINCE: {
                this.queuePolicy = new PrinceBasicQueuePolicy(this);
                break;
            }
            case GREEDYPLUS: {
                this.queuePolicy = new GreedyPlusQueuePolicy(this);
                break;
            }
            case MAXMIN: {
                this.queuePolicy = new MaxMinQueuePolicy(this);
                break;
            }
            default: {
                this.logger.logLineMand("Unexpected queue policy : " + (Object)((Object)this.queuePolicyType));
                this.logger.logLineMand("Using DropTail be default.");
                this.queuePolicyType = EnumQueuePolicy.DROPTAIL;
                this.queuePolicy = new DropTailQueuePolicy(this);
            }
        }
    }

    public void playRound() {
        int totalRequestForRound = 0;
        int i = 0;
        while (i < this.windowGame.nFlows) {
            totalRequestForRound += this.windowGame.requestArray[i];
            ++i;
        }
        this.totalRequestedPackets += totalRequestForRound;
        this.queuePolicy.playRound();
        int totalAcceptedForRound = 0;
        int i2 = 0;
        while (i2 < this.windowGame.nFlows) {
            totalAcceptedForRound += this.windowGame.acceptArray[i2];
            ++i2;
        }
        this.totalAcceptedPackets += totalAcceptedForRound;
    }

    @Override
    public int getRoundCapacity() {
        return this.windowGame.roundCapacity;
    }

    @Override
    public int getNumOfFlows() {
        return this.windowGame.nFlows;
    }

    @Override
    public int[] getRequestArray() {
        return this.windowGame.requestArray;
    }

    @Override
    public int[] getAcceptArray() {
        return this.windowGame.acceptArray;
    }

    public void initRouterStats() {
        this.totalRequestedPackets = 0;
        this.totalAcceptedPackets = 0;
    }

    public RouterStats getRouterStats() {
        RouterStats rStats = new RouterStats();
        rStats.blendNum = 1;
        rStats.queuePolicyType = this.queuePolicyType;
        rStats.totalPacketsArrived = this.totalRequestedPackets;
        rStats.totalPacketsServed = this.totalAcceptedPackets;
        return rStats;
    }
}

