/*
 * Decompiled with CFR 0.152.
 */
package netknack.light;

import java.io.PrintStream;
import java.util.Random;
import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.EnumQueuePolicy;
import netknack.light.Flow;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.Router;
import netknack.light.stats.FlowStats;
import netknack.light.stats.GameStats;

public class WindowGame {
    Logger logger;
    int gameID;
    GameParams gameparams;
    boolean gameOn = false;
    Router router;
    Flow[] flowArray;
    int[] requestArray;
    int[] acceptArray;
    int[] goodput;
    int roundNumber;
    int pregameRoundNumber;
    public final Random random;
    int duration;
    int pregameRounds;
    int capacity;
    int roundCapacity;
    int previousRoundCapacity;
    int variableCapacity;
    int totalCapacityInAllRounds;
    EnumFlowPenalty penalty;
    EnumQueuePolicy queuePolicyType;
    int nFlows;
    EnumFlowController flowPolicyType;
    int[] aArray;
    double[] bArray;
    int aDeviator;
    double bDeviator;
    long seed;
    int round = 0;

    public WindowGame(GameParams gameParams, Logger parLogger) {
        this(gameParams.gameID, parLogger, gameParams.duration, gameParams.pregameRounds, gameParams.capacity, gameParams.variableCapacity, gameParams.penalty, gameParams.queuePolicyType, gameParams.nFlows, gameParams.flowPolicyType, gameParams.aArray, gameParams.bArray, gameParams.seed);
        this.gameparams = gameParams;
    }

    public WindowGame(int parGameID, Logger parLogger, int parDuration, int parPregameRounds, int parCapacity, int parVariableCapacity, EnumFlowPenalty parPenalty, EnumQueuePolicy parQueuePolicyType, int parNFlows, EnumFlowController parFlowPolicyType, int[] parA, double[] parB, long parSeed) {
        this.logger = parLogger;
        this.gameID = parGameID;
        this.duration = parDuration;
        this.pregameRounds = parPregameRounds;
        this.roundCapacity = this.previousRoundCapacity = parCapacity;
        this.capacity = this.previousRoundCapacity;
        this.variableCapacity = parVariableCapacity;
        this.totalCapacityInAllRounds = 0;
        this.penalty = parPenalty;
        this.queuePolicyType = parQueuePolicyType;
        this.nFlows = parNFlows;
        this.flowPolicyType = parFlowPolicyType;
        int[] aArray = new int[this.nFlows];
        aArray = parA;
        double[] bArray = new double[this.nFlows];
        bArray = parB;
        this.seed = parSeed;
        if (this.seed < 0L) {
            this.random = new Random();
            long seed = this.random.nextLong();
            this.random.setSeed(seed);
        } else {
            this.random = new Random(this.seed);
        }
        this.router = new Router(this.gameparams, this.logger, this, this.queuePolicyType);
        this.flowArray = new Flow[this.nFlows];
        int i = 0;
        while (i < this.nFlows) {
            this.flowArray[i] = new Flow(i, this.logger, this.gameparams, this, this.random.nextInt(this.capacity), this.flowPolicyType, aArray[i], bArray[i], this.penalty);
            ++i;
        }
        this.requestArray = new int[this.nFlows];
        this.acceptArray = new int[this.nFlows];
        this.goodput = new int[this.nFlows];
        this.roundNumber = 0;
        this.pregameRoundNumber = 0;
    }

    public int getRoundCapacity() {
        int thisRoundCapacity = this.capacity;
        if (this.variableCapacity > 0) {
            thisRoundCapacity = this.previousRoundCapacity;
            double percentage = 0.01 * (double)this.variableCapacity;
            int variation = (int)(percentage * (double)this.capacity);
            int minCapacity = this.capacity - variation;
            int maxCapacity = this.capacity + variation;
            boolean increase = this.random.nextBoolean();
            thisRoundCapacity = increase ? ++thisRoundCapacity : --thisRoundCapacity;
            thisRoundCapacity = Math.max(thisRoundCapacity, minCapacity);
            this.previousRoundCapacity = thisRoundCapacity = Math.min(thisRoundCapacity, maxCapacity);
        }
        return thisRoundCapacity;
    }

    public void playRound() {
        this.gameOn = true;
        this.roundCapacity = this.getRoundCapacity();
        this.totalCapacityInAllRounds += this.roundCapacity;
        int totalRequest = 0;
        int i = 0;
        while (i < this.nFlows) {
            this.requestArray[i] = this.flowArray[i].requestedPackets();
            totalRequest += this.requestArray[i];
            ++i;
        }
        this.router.playRound();
        i = 0;
        while (i < this.nFlows) {
            this.flowArray[i].acceptedPackets(this.acceptArray[i]);
            ++i;
        }
    }

    public void playPregameRound() {
        this.roundCapacity = this.getRoundCapacity();
        int totalRequest = 0;
        int i = 0;
        while (i < this.nFlows) {
            this.requestArray[i] = this.flowArray[i].requestedPackets();
            totalRequest += this.requestArray[i];
            ++i;
        }
        this.router.playRound();
        i = 0;
        while (i < this.nFlows) {
            this.flowArray[i].acceptedPackets(this.acceptArray[i]);
            ++i;
        }
        ++this.pregameRoundNumber;
    }

    public void playPregame() {
        int i = 0;
        while (i < this.pregameRounds) {
            this.playPregameRound();
            ++i;
        }
    }

    public void playGame() {
        int i = 0;
        while (i < this.duration) {
            this.playRound();
            ++i;
        }
    }

    public void getPenaltyStats() {
        int[] numPenalties = new int[this.nFlows];
        int[] numPenaltyRounds = new int[this.nFlows];
        int i = 0;
        while (i < this.nFlows) {
            numPenalties[i] = this.flowArray[i].getNumPenalties();
            numPenaltyRounds[i] = this.flowArray[i].getNumPenaltyRounds();
            this.logger.logLine("Flow" + i + " penalties=" + numPenalties[i] + ",penaltyRounds=" + numPenaltyRounds[i]);
            ++i;
        }
    }

    public void playAllRounds() {
        this.playPregame();
        this.initGameStats();
        this.playGame();
    }

    public int[] getGoodput() {
        int i = 0;
        while (i < this.nFlows) {
            this.goodput[i] = this.flowArray[i].getTotalAcceptedPackets();
            ++i;
        }
        return this.goodput;
    }

    public void printStats(PrintStream pst) {
        pst.println("Statistics for the game:");
        int i = 0;
        while (i < this.nFlows) {
            pst.println("Flow : " + i + ", Requested Packets : " + this.flowArray[i].getTotalRequestedPackets() + ", Accepted Packets : " + this.flowArray[i].getTotalAcceptedPackets());
            ++i;
        }
    }

    public void initGameStats() {
        this.router.initRouterStats();
        int i = 0;
        while (i < this.nFlows) {
            this.flowArray[i].initFlowStats();
            ++i;
        }
        this.totalCapacityInAllRounds = 0;
    }

    public GameStats getGameStats() {
        GameStats stats = new GameStats();
        stats.blendNum = 1;
        stats.gameID = this.gameID;
        stats.rounds = this.duration;
        stats.flowPolicyType = this.flowPolicyType;
        stats.penalty = this.penalty;
        stats.routerStats = this.router.getRouterStats();
        stats.nFlows = this.nFlows;
        stats.flowStats = new FlowStats[this.nFlows];
        int i = 0;
        while (i < this.nFlows) {
            stats.flowStats[i] = this.flowArray[i].getFlowStats();
            ++i;
        }
        stats.capacity = this.capacity;
        stats.totalCapacityInAllRounds = this.totalCapacityInAllRounds;
        return stats;
    }
}

