/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import netknack.light.Finals;
import netknack.light.NetKnackUI;
import netknack.light.app.TableModelParameters;
import netknack.light.symmetricNE.SymmetricNE;

public class SimpleGuiApp
implements NetKnackUI {
    private SymmetricNE symmetricNE;
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu editMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem cutMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem pasteMenuItem = null;
    private JMenuItem saveMenuItem = null;
    private JDialog aboutDialog = null;
    private JPanel aboutContentPane = null;
    private JLabel aboutVersionLabel = null;
    private JScrollPane jScrollPaneConsole = null;
    private JLabel jLabelConsole = null;
    private JTextArea jTextAreaConsole = null;
    private JScrollPane jScrollPaneParameters = null;
    private JTable jTableParameters = null;
    private JButton jButtonSubmit = null;

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setDefaultCloseOperation(3);
            this.jFrame.setTitle("NetKnack Simple GUI");
            this.jFrame.setJMenuBar(this.getJJMenuBar());
            this.jFrame.setSize(661, 366);
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.setTitle("NetKnack Simple GUI");
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelConsole = new JLabel();
            this.jLabelConsole.setBounds(new Rectangle(259, 71, 85, 23));
            this.jLabelConsole.setText("Console:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJScrollPaneConsole(), null);
            this.jContentPane.add((Component)this.jLabelConsole, null);
            this.jContentPane.add((Component)this.getJScrollPaneParameters(), null);
            this.jContentPane.add((Component)this.getJButtonSubmit(), null);
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getEditMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.add(this.getCutMenuItem());
            this.editMenu.add(this.getCopyMenuItem());
            this.editMenu.add(this.getPasteMenuItem());
        }
        return this.editMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog aboutDialog = SimpleGuiApp.this.getAboutDialog();
                    aboutDialog.pack();
                    Point loc = SimpleGuiApp.this.getJFrame().getLocation();
                    loc.translate(20, 20);
                    aboutDialog.setLocation(loc);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JDialog((Frame)this.getJFrame(), true);
            this.aboutDialog.setTitle("About");
            this.aboutDialog.setContentPane(this.getAboutContentPane());
        }
        return this.aboutDialog;
    }

    private JPanel getAboutContentPane() {
        if (this.aboutContentPane == null) {
            this.aboutContentPane = new JPanel();
            this.aboutContentPane.setLayout(new BorderLayout());
            this.aboutContentPane.add((Component)this.getAboutVersionLabel(), "Center");
        }
        return this.aboutContentPane;
    }

    private JLabel getAboutVersionLabel() {
        if (this.aboutVersionLabel == null) {
            this.aboutVersionLabel = new JLabel();
            this.aboutVersionLabel.setText("NetKnack, v" + Finals.version);
            this.aboutVersionLabel.setHorizontalAlignment(0);
        }
        return this.aboutVersionLabel;
    }

    private JMenuItem getCutMenuItem() {
        if (this.cutMenuItem == null) {
            this.cutMenuItem = new JMenuItem();
            this.cutMenuItem.setText("Cut");
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, true));
        }
        return this.cutMenuItem;
    }

    private JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            this.copyMenuItem = new JMenuItem();
            this.copyMenuItem.setText("Copy");
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
        }
        return this.copyMenuItem;
    }

    private JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            this.pasteMenuItem = new JMenuItem();
            this.pasteMenuItem.setText("Paste");
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
        }
        return this.pasteMenuItem;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
        }
        return this.saveMenuItem;
    }

    private JScrollPane getJScrollPaneConsole() {
        if (this.jScrollPaneConsole == null) {
            this.jScrollPaneConsole = new JScrollPane();
            this.jScrollPaneConsole.setBounds(new Rectangle(259, 98, 385, 199));
            this.jScrollPaneConsole.setViewportView(this.getJTextAreaConsole());
        }
        return this.jScrollPaneConsole;
    }

    private JTextArea getJTextAreaConsole() {
        if (this.jTextAreaConsole == null) {
            this.jTextAreaConsole = new JTextArea();
            this.jTextAreaConsole.setEditable(false);
        }
        return this.jTextAreaConsole;
    }

    private JScrollPane getJScrollPaneParameters() {
        if (this.jScrollPaneParameters == null) {
            this.jScrollPaneParameters = new JScrollPane();
            this.jScrollPaneParameters.setBounds(new Rectangle(12, 15, 237, 281));
            this.jScrollPaneParameters.setViewportView(this.getJTableParameters());
        }
        return this.jScrollPaneParameters;
    }

    private JTable getJTableParameters() {
        if (this.jTableParameters == null) {
            this.jTableParameters = new JTable(new TableModelParameters());
        }
        return this.jTableParameters;
    }

    private JButton getJButtonSubmit() {
        if (this.jButtonSubmit == null) {
            this.jButtonSubmit = new JButton();
            this.jButtonSubmit.setBounds(new Rectangle(375, 15, 106, 31));
            this.jButtonSubmit.setText("Submit");
            SimpleGuiApp netKnackUI = this;
            this.jButtonSubmit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleGuiApp.this.runExperiment();
                }
            });
        }
        return this.jButtonSubmit;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGuiApp application = new SimpleGuiApp();
                application.getJFrame().setVisible(true);
            }
        });
    }

    @Override
    public void logLine(String s) {
        this.jTextAreaConsole.append(String.valueOf(s) + "\n");
    }

    private void runExperiment() {
        this.jButtonSubmit.setEnabled(false);
        int numOfArgs = this.jTableParameters.getRowCount();
        String[] args = new String[numOfArgs];
        int i = 0;
        while (i < numOfArgs) {
            args[i] = (String)this.jTableParameters.getValueAt(i, 1);
            ++i;
        }
        this.symmetricNE = new SymmetricNE(this, args);
        this.symmetricNE.execute();
        this.jButtonSubmit.setEnabled(true);
    }
}

