/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.asymmetricNE;

import java.io.PrintStream;
import netknack.light.BlendedWindowGame;
import netknack.light.EnumExperimentType;
import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.EnumGameType;
import netknack.light.EnumQueuePolicy;
import netknack.light.Finals;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.NetKnackUI;
import netknack.light.WindowGame;
import netknack.light.asymmetricNE.AsymmetricAPI;
import netknack.light.asymmetricNE.ParamCompute;
import netknack.light.asymmetricNE.ParamComputeAPI;

public class AsymmetricNE
implements AsymmetricAPI {
    public NetKnackUI nkUI;
    Logger logger;
    EnumExperimentType experimentType;
    int blendNum;
    int gameID;
    int maxA = 50;
    int minA = 1;
    double maxB = 0.99;
    double minB = 0.5;
    int variationA = 1;
    int variationB = 1;
    int goodput;
    int flowNum;
    int pregameRounds;
    int duration;
    boolean gameOn;
    GameParams gameParams;
    PrintStream logpst;
    String str;
    ParamComputeAPI paramComputeAPI;

    public AsymmetricNE(NetKnackUI netKnackUI, String[] args) {
        this.nkUI = netKnackUI;
        this.nkUI.logLine("Creating experiment with NetKnack v" + Finals.version);
        this.gameParams = new GameParams();
        this.gameParams.gameType = EnumGameType.parseGameType(args[0]);
        this.experimentType = EnumExperimentType.parseExperimentType(args[1]);
        this.blendNum = Integer.parseInt(args[2]);
        this.gameParams.gameID = Integer.parseInt(args[3]);
        this.gameParams.duration = Integer.parseInt(args[4]);
        this.gameParams.pregameRounds = Integer.parseInt(args[5]);
        this.gameParams.capacity = Integer.parseInt(args[6]);
        this.gameParams.variableCapacity = Integer.parseInt(args[7]);
        this.gameParams.penalty = EnumFlowPenalty.parseFlowPenalty(args[8]);
        this.gameParams.queuePolicyType = EnumQueuePolicy.parseQueuePolicy(args[9]);
        this.gameParams.nFlows = Integer.parseInt(args[10]);
        this.gameParams.flowPolicyType = EnumFlowController.parseFlowController(args[11]);
        this.gameParams.SetArrays(this.gameParams.nFlows);
        int i = 0;
        while (i < this.gameParams.nFlows) {
            this.gameParams.bArray[i] = Double.parseDouble(args[13]);
            ++i;
        }
        this.gameParams.seed = Long.parseLong(args[16]);
        this.logger = new Logger(this.nkUI, this.gameParams);
        this.paramComputeAPI = new ParamCompute(this, this.logger, this.gameParams);
        this.str = "duration=" + this.gameParams.duration + ",blended=" + this.blendNum + ",flows=" + this.gameParams.nFlows + ",capacity=" + this.gameParams.capacity + ",penalty=" + (Object)((Object)this.gameParams.penalty) + ",policy=" + (Object)((Object)this.gameParams.queuePolicyType);
    }

    public void playGamesForAllA() {
        int minA = 1;
        int maxA = this.gameParams.capacity;
        int a = minA;
        while (a <= maxA) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a++;
            WindowGame wg = new WindowGame(this.gameParams, this.logger);
            wg.playAllRounds();
            this.logger.logLine(wg.getGameStats().toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void playBlendedGamesForAllA(int blendNum) {
        this.paramComputeAPI.setStartingParamsA();
        ** GOTO lbl12
        {
            this.gameParams.aArray = this.paramComputeAPI.getParamsA();
            bwg = new BlendedWindowGame(this.logger, blendNum, this.gameParams);
            bwg.playAllRounds();
            this.flowNum = this.paramComputeAPI.getFlowNum();
            this.goodput = bwg.getGameStats().getGoodput(this.flowNum);
            this.paramComputeAPI.setGoodputA();
            do {
                if (this.paramComputeAPI.RoundOn()) continue block0;
                this.paramComputeAPI.computeNextRoundParamsA();
lbl12:
                // 2 sources

            } while (this.paramComputeAPI.GameOn());
        }
        this.logger.logLine(this.str);
    }

    /*
     * Unable to fully structure code
     */
    public void playBlendedGamesForAllB(int blendNum) {
        this.paramComputeAPI.setStartingParamsB();
        ** GOTO lbl12
        {
            this.gameParams.bArray = this.paramComputeAPI.getParamsB();
            bwg = new BlendedWindowGame(this.logger, blendNum, this.gameParams);
            bwg.playAllRounds();
            this.flowNum = this.paramComputeAPI.getFlowNum();
            this.goodput = bwg.getGameStats().getGoodput(this.flowNum);
            this.paramComputeAPI.setGoodputB();
            do {
                if (this.paramComputeAPI.RoundOn()) continue block0;
                this.paramComputeAPI.computeNextRoundParamsB();
lbl12:
                // 2 sources

            } while (this.paramComputeAPI.GameOn());
        }
    }

    @Override
    public int getGoodput() {
        return this.goodput;
    }

    @Override
    public int getMaxA() {
        return this.maxA;
    }

    @Override
    public int getMinA() {
        return this.minA;
    }

    @Override
    public double getMaxB() {
        return this.maxB;
    }

    @Override
    public double getMinB() {
        return this.minB;
    }

    @Override
    public int getVariationA() {
        return this.variationA;
    }

    @Override
    public double getVariationB() {
        return this.variationB;
    }

    public void execute() {
        this.logger.logLine("Starting AsymmetricNE Game...");
        switch (this.experimentType) {
            case BGAME_ALL_A: {
                this.playBlendedGamesForAllA(this.blendNum);
                break;
            }
            case BGAME_ALL_B: {
                this.playBlendedGamesForAllB(this.blendNum);
                break;
            }
            default: {
                System.err.println("Unexpected One-Shot game type! Type must be one of {BGAME_ALL_A, BGAME_ALL_B}!");
            }
        }
        this.logger.logLine("AsymmetricNE Game terminated !");
    }
}

