/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.asymmetricNE;

import java.util.Arrays;
import java.util.Vector;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.asymmetricNE.AsymmetricAPI;
import netknack.light.asymmetricNE.ParamComputeAPI;

public class ParamCompute
implements ParamComputeAPI {
    Logger logger;
    int maxA;
    int minA;
    double maxB;
    double minB;
    int variationA;
    double variationB;
    int[] startingParamsA;
    int[][] allRoundsparamsA;
    int[][] goodputA;
    int[] paramsA;
    int[] roundParamsA;
    Vector allParamsA = new Vector();
    double[] startingParamsB;
    double[][] allRoundsparamsB;
    int[][] goodputB;
    double[] roundParamsB;
    Vector allParamsB = new Vector();
    double[] paramsB;
    int nFlows;
    boolean gameOn = true;
    boolean roundOn = true;
    int roundNum = 0;
    int flowNum = 0;
    int flowParam = 0;
    AsymmetricAPI asymmetricAPI;
    Double iterations;

    public ParamCompute(AsymmetricAPI parAsymmetricAPI, Logger parLogger, GameParams gameParams) {
        this.logger = parLogger;
        this.asymmetricAPI = parAsymmetricAPI;
        this.maxA = this.asymmetricAPI.getMaxA();
        this.minA = this.asymmetricAPI.getMinA();
        this.maxB = this.asymmetricAPI.getMaxB();
        this.minB = this.asymmetricAPI.getMinB();
        this.variationA = this.asymmetricAPI.getVariationA();
        this.variationB = this.asymmetricAPI.getVariationB();
        this.nFlows = gameParams.nFlows;
        this.paramsA = new int[this.nFlows];
        this.paramsB = new double[this.nFlows];
        this.roundParamsA = new int[this.nFlows];
        this.roundParamsB = new double[this.nFlows];
        this.startingParamsA = new int[this.nFlows];
        this.allRoundsparamsA = new int[this.nFlows][this.maxA - this.minA + 1];
        this.startingParamsB = new double[this.nFlows];
        this.allRoundsparamsB = new double[this.nFlows][(int)((this.maxB - this.minB) * 100.0 + 1.0)];
        this.goodputA = new int[this.nFlows][this.maxA - this.minA + 1];
        Double lenght = new Double((this.maxB - this.minB) * 100.0 + 1.0);
        this.goodputB = new int[this.nFlows][lenght.intValue()];
        this.iterations = new Double((this.maxB - this.minB) * 100.0 + 1.0);
    }

    @Override
    public void setStartingParamsA() {
        this.logger.logLine("Starting experiment ...");
        this.logger.logLine("Round " + this.roundNum + " started");
        int i = 0;
        while (i < this.nFlows) {
            Double parA = new Double((double)this.maxA * Math.random() + (double)this.minA);
            this.startingParamsA[i] = parA.intValue();
            this.roundParamsA[i] = this.startingParamsA[i];
            this.allRoundsparamsA[i][0] = this.minA;
            int a = 1;
            while ((double)a < this.iterations) {
                this.allRoundsparamsA[i][a] = this.allRoundsparamsA[i][a - 1] + 1;
                ++a;
            }
            ++i;
        }
        this.allParamsA.addElement(this.roundParamsA);
    }

    @Override
    public void setFixedStartingParamsA() {
        this.logger.logLine("Starting experiment ...");
        this.logger.logLine("Round " + this.roundNum + " started");
        this.startingParamsA[0] = 1;
        this.startingParamsA[1] = 2;
        this.startingParamsA[2] = 3;
        this.startingParamsA[3] = 4;
        this.startingParamsA[4] = 5;
        this.startingParamsA[5] = 6;
        this.startingParamsA[6] = 7;
        this.startingParamsA[7] = 8;
        this.startingParamsA[8] = 9;
        this.startingParamsA[9] = 10;
        int i = 0;
        while (i < this.nFlows) {
            this.roundParamsA[i] = this.startingParamsA[i];
            this.allRoundsparamsA[i][0] = this.minA;
            int a = 1;
            while ((double)a < this.iterations) {
                this.allRoundsparamsA[i][a] = this.allRoundsparamsA[i][a - 1] + 1;
                ++a;
            }
            ++i;
        }
        this.allParamsA.addElement(this.roundParamsA);
    }

    void setNextParamsA() {
        if (this.flowParam > this.maxA - 1) {
            this.flowParam = 0;
            ++this.flowNum;
        }
        if (this.flowNum == this.nFlows - 1 && this.flowParam == this.maxA - 1) {
            this.roundOn = false;
        }
        int a = 0;
        while (a < this.nFlows) {
            this.paramsA[a] = this.startingParamsA[a];
            ++a;
        }
        this.paramsA[this.flowNum] = this.allRoundsparamsA[this.flowNum][this.flowParam];
    }

    @Override
    public void setStartingParamsB() {
        this.logger.logLine("Starting experiment ...");
        this.logger.logLine("Round " + this.roundNum + " started");
        int i = 0;
        while (i < this.nFlows) {
            Double parB1 = new Double(Math.random() * (this.maxB - this.minB) * 100.0);
            Double parB = new Double(this.minB + 0.01 * (double)parB1.intValue());
            this.startingParamsB[i] = parB;
            this.roundParamsB[i] = this.startingParamsB[i];
            this.allRoundsparamsB[i][0] = this.minB;
            this.logger.logLine("startingParamsB[" + i + "]=" + this.startingParamsB[i]);
            int a = 1;
            while (a < this.iterations.intValue()) {
                this.allRoundsparamsB[i][a] = this.allRoundsparamsB[i][a - 1] + 0.01;
                ++a;
            }
            ++i;
        }
        this.allParamsB.addElement(this.roundParamsB);
    }

    void setNextParamsB() {
        if (this.flowParam > this.iterations.intValue() - 1) {
            this.flowParam = 0;
            ++this.flowNum;
        }
        if (this.flowNum == this.nFlows - 1 && this.flowParam == this.iterations.intValue() - 1) {
            this.roundOn = false;
        }
        int a = 0;
        while (a < this.nFlows) {
            this.paramsB[a] = this.startingParamsB[a];
            ++a;
        }
        this.paramsB[this.flowNum] = this.allRoundsparamsB[this.flowNum][this.flowParam];
    }

    @Override
    public void computeNextRoundParamsA() {
        ++this.roundNum;
        this.logger.logLine("Round " + this.roundNum + " started");
        this.roundOn = true;
        this.flowParam = 0;
        int i = 0;
        while (i < this.nFlows) {
            int maxGoodput = 0;
            int a = 0;
            while (a < this.maxA) {
                if ((double)this.goodputA[i][a] > 1.02 * (double)maxGoodput) {
                    this.paramsA[i] = this.allRoundsparamsA[i][a];
                    maxGoodput = this.goodputA[i][a];
                }
                ++a;
            }
            ++i;
        }
        if (this.roundNum > 20) {
            this.gameOn = false;
        }
        if (Arrays.equals(this.startingParamsA, this.paramsA)) {
            this.gameOn = false;
        }
        int[] roundParamsA = new int[this.nFlows];
        int i2 = 0;
        while (i2 < this.nFlows) {
            roundParamsA[i2] = this.paramsA[i2];
            this.startingParamsA[i2] = this.paramsA[i2];
            ++i2;
        }
        this.allParamsA.addElement(roundParamsA);
        if (!this.gameOn) {
            this.logger.logLine("end of round");
            this.logger.logLine("end of game !");
            this.printHistoryA();
            this.logger.logLine("AsymmetricNE terminated !");
        }
    }

    @Override
    public void computeNextRoundParamsB() {
        this.logger.logLine("end of round");
        ++this.roundNum;
        this.logger.logLine("Round " + this.roundNum + " started");
        this.roundOn = true;
        this.flowParam = 0;
        int i = 0;
        while (i < this.nFlows) {
            int maxGoodput = 0;
            int a = 0;
            while (a < this.iterations.intValue()) {
                if ((double)this.goodputB[i][a] > 0.99 * (double)maxGoodput) {
                    this.paramsB[i] = this.allRoundsparamsB[i][a];
                    maxGoodput = this.goodputB[i][a];
                }
                ++a;
            }
            ++i;
        }
        if (this.roundNum > 100) {
            this.gameOn = false;
        }
        if (Arrays.equals(this.startingParamsB, this.paramsB)) {
            this.gameOn = false;
        }
        double[] roundParamsB = new double[this.nFlows];
        int i2 = 0;
        while (i2 < this.nFlows) {
            roundParamsB[i2] = this.paramsB[i2];
            this.startingParamsB[i2] = this.paramsB[i2];
            ++i2;
        }
        this.allParamsB.addElement(roundParamsB);
        if (!this.gameOn) {
            this.logger.logLine("end of round");
            this.logger.logLine("end of game !");
            this.printHistoryB();
            this.logger.logLine("AsymmetricNE terminated !");
        }
    }

    @Override
    public void setGoodputA() {
        this.goodputA[this.flowNum][this.flowParam] = this.asymmetricAPI.getGoodput();
        ++this.flowParam;
        if (!this.roundOn) {
            this.flowNum = 0;
        }
    }

    @Override
    public void setGoodputB() {
        this.goodputB[this.flowNum][this.flowParam] = this.asymmetricAPI.getGoodput();
        ++this.flowParam;
        if (!this.roundOn) {
            this.flowNum = 0;
        }
    }

    void printHistoryA() {
        int a;
        int[][] allRoundHistory = new int[this.roundNum + 1][this.nFlows];
        String allA = "";
        int i = 0;
        while (i <= this.roundNum) {
            int[] oneRoundHistory = (int[])this.allParamsA.get(i);
            a = 0;
            while (a < this.nFlows) {
                allRoundHistory[i][a] = oneRoundHistory[a];
                ++a;
            }
            ++i;
        }
        i = 0;
        while (i <= this.roundNum) {
            a = 0;
            while (a < this.nFlows) {
                allA = String.valueOf(allA) + " " + allRoundHistory[i][a];
                ++a;
            }
            this.logger.logLine("Round=" + (i + 1) + "--->  " + allA);
            allA = "";
            ++i;
        }
    }

    void printHistoryB() {
        int a;
        double[][] allRoundHistory = new double[this.roundNum + 1][this.nFlows];
        String allB = "";
        int i = 0;
        while (i <= this.roundNum) {
            double[] oneRoundHistory = (double[])this.allParamsB.get(i);
            a = 0;
            while (a < this.nFlows) {
                allRoundHistory[i][a] = oneRoundHistory[a];
                ++a;
            }
            ++i;
        }
        i = 0;
        while (i <= this.roundNum) {
            a = 0;
            while (a < this.nFlows) {
                allB = String.valueOf(allB) + " " + allRoundHistory[i][a];
                ++a;
            }
            this.logger.logLine("Round=" + (i + 1) + "--->  " + allB);
            allB = "";
            ++i;
        }
    }

    @Override
    public int[] getParamsA() {
        this.setNextParamsA();
        return this.paramsA;
    }

    @Override
    public double[] getParamsB() {
        this.setNextParamsB();
        return this.paramsB;
    }

    boolean getGameStatus() {
        return this.gameOn;
    }

    @Override
    public int getFlowNum() {
        return this.flowNum;
    }

    @Override
    public boolean GameOn() {
        return this.gameOn;
    }

    @Override
    public boolean RoundOn() {
        return this.roundOn;
    }
}

