/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.flowcontrol;

import netknack.light.EnumFlowPenalty;
import netknack.light.FlowControlAPI;
import netknack.light.flowcontrol.FlowController;

public class AIMDFlowController
extends FlowController {
    int a;
    double b;
    int standardPenaltyRounds = 3;
    double g = 1.0;
    int currentPenaltyRound = -1;
    int severePackets = -1;
    int losses = 0;
    int numPenalties = 0;
    int numPenaltyRounds = 0;
    int lastWindowSize = 0;

    public AIMDFlowController(FlowControlAPI flowControlAPI, int parA, double parB) {
        super(flowControlAPI);
        this.a = parA;
        this.b = parB;
    }

    @Override
    public void beginRound() {
    }

    @Override
    public void endRound() {
        int requestedPackets = this.flowControlAPI.getWindowSizeInt();
        int acceptedPackets = this.flowControlAPI.getAcceptedPackets();
        int newWindowSize = -1;
        EnumFlowPenalty penaltyType = this.flowControlAPI.getPenalty();
        switch (penaltyType) {
            case HYBRID: {
                if (this.currentPenaltyRound > 0) {
                    --this.currentPenaltyRound;
                    newWindowSize = 0;
                } else if (this.currentPenaltyRound == 0) {
                    Double newWindow = new Double(this.lastWindowSize / this.losses);
                    newWindowSize = newWindow.intValue();
                    --this.currentPenaltyRound;
                } else if (acceptedPackets < requestedPackets) {
                    if (acceptedPackets < requestedPackets - 1) {
                        ++this.numPenalties;
                        this.losses = requestedPackets - acceptedPackets;
                        this.currentPenaltyRound = this.standardPenaltyRounds + this.losses - 1;
                        if (this.currentPenaltyRound > 15) {
                            this.currentPenaltyRound = 15;
                        }
                        this.numPenaltyRounds += this.currentPenaltyRound;
                        this.lastWindowSize = requestedPackets;
                        newWindowSize = 0;
                    } else if (acceptedPackets == requestedPackets - 1) {
                        newWindowSize = (int)Math.max(1.0, (double)requestedPackets * this.b - this.g);
                    }
                } else {
                    newWindowSize = acceptedPackets + this.a;
                }
                this.flowControlAPI.setWindowSize(newWindowSize);
                break;
            }
            case GENTLE: {
                if (acceptedPackets < requestedPackets) {
                    this.losses = requestedPackets - acceptedPackets;
                    newWindowSize = (int)Math.max(1.0, (double)requestedPackets * this.b - this.g * (double)this.losses);
                    ++this.numPenalties;
                    this.numPenaltyRounds += this.losses;
                } else {
                    newWindowSize = acceptedPackets + this.a;
                }
                this.flowControlAPI.setWindowSize(newWindowSize);
                break;
            }
            case SEVERE: {
                if (this.currentPenaltyRound > 0) {
                    --this.currentPenaltyRound;
                    newWindowSize = 0;
                } else if (this.currentPenaltyRound == 0) {
                    Double newWindow = new Double(this.b * (double)this.severePackets);
                    newWindowSize = newWindow.intValue();
                    --this.currentPenaltyRound;
                } else if (acceptedPackets < requestedPackets) {
                    this.currentPenaltyRound = this.standardPenaltyRounds - 1;
                    newWindowSize = 0;
                    this.severePackets = requestedPackets;
                } else {
                    newWindowSize = acceptedPackets + this.a;
                }
                this.flowControlAPI.setWindowSize(newWindowSize);
            }
        }
    }

    @Override
    public int numPenalties() {
        return this.numPenalties;
    }

    @Override
    public int numPenaltyRounds() {
        return this.numPenaltyRounds;
    }
}

