/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.oneShotGame;

import netknack.light.EnumExperimentType;
import netknack.light.EnumGameType;
import netknack.light.EnumQueuePolicy;
import netknack.light.Finals;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.NetKnackUI;
import netknack.light.oneShotGame.OneShotWindowGame;

public class OneShot {
    public NetKnackUI nkUI;
    public Logger logger;
    int gameID;
    EnumExperimentType oneShotGame;
    GameParams gameParams;

    public OneShot(NetKnackUI netKnackUI, String[] args) {
        this.nkUI = netKnackUI;
        this.nkUI.logLine("Creating experiment with NetKnack v" + Finals.version);
        this.gameParams = new GameParams();
        this.gameParams.gameType = EnumGameType.parseGameType(args[0]);
        this.oneShotGame = EnumExperimentType.parseExperimentType(args[1]);
        this.gameParams.blendNum = Integer.parseInt(args[2]);
        this.gameParams.gameID = Integer.parseInt(args[3]);
        this.gameParams.capacity = Integer.parseInt(args[6]);
        this.gameParams.queuePolicyType = EnumQueuePolicy.parseQueuePolicy(args[9]);
        this.gameParams.nFlows = Integer.parseInt(args[10]);
        this.gameParams.SetArrays(this.gameParams.nFlows);
        int i = 0;
        while (i < this.gameParams.nFlows - 1) {
            this.gameParams.aArray[i] = Integer.parseInt(args[12]);
            ++i;
        }
        this.gameParams.aArray[this.gameParams.nFlows - 1] = Integer.parseInt(args[14]);
        this.logger = new Logger(this.nkUI, this.gameParams);
    }

    public void playGame() {
        int minWindow = 1;
        int maxWindow = this.gameParams.capacity;
        int a = minWindow;
        while (a <= maxWindow) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a++;
            OneShotWindowGame wg = new OneShotWindowGame(oneGame, this.logger);
            wg.playGame();
        }
    }

    public void playGameForAllSymmetric() {
        int minWindow = 1;
        int maxWindow = this.gameParams.capacity;
        int i = minWindow;
        while (i <= maxWindow) {
            int k = 0;
            while (k < this.gameParams.nFlows - 1) {
                this.gameParams.aArray[k] = i;
                ++k;
            }
            int a = minWindow;
            while (a <= maxWindow) {
                GameParams oneGame = this.gameParams.clone();
                oneGame.gameID = this.gameParams.gameID + a;
                oneGame.aArray[oneGame.nFlows - 1] = a++;
                OneShotWindowGame wg = new OneShotWindowGame(oneGame, this.logger);
                wg.playGame();
            }
            ++i;
        }
    }

    public void execute() {
        this.logger.logLine("Starting One-Shot Game...");
        this.logger.logLine("flows=" + this.gameParams.nFlows + ",capacity=" + this.gameParams.capacity + ",blendNum=" + this.gameParams.blendNum + ",queuePolicy=" + (Object)((Object)this.gameParams.queuePolicyType) + ",game=" + (Object)((Object)this.oneShotGame));
        switch (this.oneShotGame) {
            case WINDOW_GAME: {
                this.playGame();
                break;
            }
            case ALL_WINDOW_GAME: {
                this.playGameForAllSymmetric();
                break;
            }
            default: {
                System.err.println("Unexpected One-Shot game type! Type must be one of {WINDOW_GAME, ALL_WINDOW_GAME}!");
            }
        }
        this.logger.logLine("One-Shot Game terminated !");
    }
}

