/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.oneShotGame;

import netknack.light.EnumQueuePolicy;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.QueuePolicyAPI;
import netknack.light.oneShotGame.OneShotWindowGame;
import netknack.light.queuepolicy.CHOKePlusQueuePolicy;
import netknack.light.queuepolicy.CHOKeQueuePolicy;
import netknack.light.queuepolicy.DropTailQueuePolicy;
import netknack.light.queuepolicy.GreedyPlusQueuePolicy;
import netknack.light.queuepolicy.MaxMinQueuePolicy;
import netknack.light.queuepolicy.PrinceBasicQueuePolicy;
import netknack.light.queuepolicy.PrinceGQueuePolicy;
import netknack.light.queuepolicy.PrinceMQueuePolicy;
import netknack.light.queuepolicy.QueuePolicy;
import netknack.light.queuepolicy.REDQueuePolicy;

public class OneShotRouter
implements QueuePolicyAPI {
    Logger logger;
    OneShotWindowGame oneShotWindowGame;
    GameParams gameparams;
    EnumQueuePolicy queuePolicyType;
    QueuePolicy queuePolicy;
    public int totalRequestedPackets;
    public int totalAcceptedPackets;

    public OneShotRouter(GameParams parGameParams, Logger parLogger, OneShotWindowGame parWindowGame, EnumQueuePolicy parQueuePolicyType) {
        this.gameparams = parGameParams;
        this.logger = parLogger;
        this.oneShotWindowGame = parWindowGame;
        this.queuePolicyType = parQueuePolicyType;
        switch (this.queuePolicyType) {
            case DROPTAIL: {
                this.queuePolicy = new DropTailQueuePolicy(this);
                break;
            }
            case RED: {
                this.queuePolicy = new REDQueuePolicy(this);
                break;
            }
            case CHOKE: {
                this.queuePolicy = new CHOKeQueuePolicy(this);
                break;
            }
            case CHOKEPLUS: {
                this.queuePolicy = new CHOKePlusQueuePolicy(this);
                break;
            }
            case PRINCEG: {
                this.queuePolicy = new PrinceGQueuePolicy(this);
                break;
            }
            case PRINCER: {
                this.queuePolicy = new PrinceMQueuePolicy(this);
                break;
            }
            case PRINCE: {
                this.queuePolicy = new PrinceBasicQueuePolicy(this);
                break;
            }
            case GREEDYPLUS: {
                this.queuePolicy = new GreedyPlusQueuePolicy(this);
                break;
            }
            case MAXMIN: {
                this.queuePolicy = new MaxMinQueuePolicy(this);
                break;
            }
            default: {
                this.logger.logLineMand("Unexpected queue policy : " + (Object)((Object)this.queuePolicyType));
                this.logger.logLineMand("Using DropTail be default.");
                this.queuePolicyType = EnumQueuePolicy.DROPTAIL;
                this.queuePolicy = new DropTailQueuePolicy(this);
            }
        }
    }

    public void playRound() {
        this.queuePolicy.playRound();
    }

    @Override
    public int getNumOfFlows() {
        return this.oneShotWindowGame.nFlows;
    }

    @Override
    public int[] getRequestArray() {
        return this.oneShotWindowGame.requestArray;
    }

    @Override
    public int[] getAcceptArray() {
        return this.oneShotWindowGame.acceptArray;
    }

    @Override
    public int getRoundCapacity() {
        return this.gameparams.capacity;
    }
}

