/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.oneShotGame;

import netknack.light.EnumQueuePolicy;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.oneShotGame.OneShotRouter;

public class OneShotWindowGame {
    Logger logger;
    int gameID;
    GameParams gameparams;
    OneShotRouter router;
    int[] requestArray;
    int[] acceptArray;
    int[] totalAcceptedArray;
    int[] totalRequestedArray;
    double utility;
    double[] packetsPerRound;
    EnumQueuePolicy queuePolicyType;
    int nFlows;
    int[] aArray;
    String str;

    public OneShotWindowGame(GameParams gameParams, Logger parLogger) {
        this.gameparams = gameParams;
        this.logger = parLogger;
        this.gameID = this.gameparams.gameID;
        this.queuePolicyType = this.gameparams.queuePolicyType;
        this.nFlows = this.gameparams.nFlows;
        this.aArray = new int[this.nFlows];
        this.aArray = this.gameparams.aArray;
        this.str = "";
        this.router = new OneShotRouter(this.gameparams, this.logger, this, this.queuePolicyType);
        this.requestArray = new int[this.nFlows];
        this.acceptArray = new int[this.nFlows];
        this.totalRequestedArray = new int[this.nFlows];
        this.totalAcceptedArray = new int[this.nFlows];
        this.packetsPerRound = new double[this.nFlows];
    }

    public void playRound() {
        int i = 0;
        while (i < this.nFlows) {
            this.requestArray[i] = this.aArray[i];
            int n = i;
            this.totalRequestedArray[n] = this.totalRequestedArray[n] + this.aArray[i];
            ++i;
        }
        this.router.playRound();
        this.acceptArray = this.router.getAcceptArray();
        i = 0;
        while (i < this.nFlows) {
            int n = i;
            this.totalAcceptedArray[n] = this.totalAcceptedArray[n] + this.acceptArray[i];
            ++i;
        }
    }

    public void playGame() {
        this.str = String.valueOf(this.str) + this.gameparams.gameID;
        int i = 0;
        while (i < this.gameparams.blendNum) {
            this.playRound();
            ++i;
        }
        i = 0;
        while (i < this.nFlows) {
            this.packetsPerRound[i] = (double)this.totalAcceptedArray[i] / (double)this.gameparams.blendNum;
            if (i != this.gameparams.nFlows - 1) {
                this.str = String.valueOf(this.str) + " " + (i + 1) + " " + this.requestArray[i] + " " + this.packetsPerRound[i];
            } else {
                this.utility = ((double)this.totalAcceptedArray[i] - 0.1 * (double)(this.totalRequestedArray[i] - this.totalAcceptedArray[i])) / (double)this.gameparams.blendNum;
                this.str = String.valueOf(this.str) + " " + (i + 1) + " " + this.requestArray[i] + " " + this.packetsPerRound[i] + " " + this.utility;
            }
            ++i;
        }
        this.logger.logLine(this.str);
    }
}

