/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class CHOKePlusQueuePolicy
extends QueuePolicy {
    public CHOKePlusQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int numCandidatePackets = 5;
        double k3 = 0.0;
        int[] candidatePacket = new int[numCandidatePackets];
        int matches = 0;
        double g1 = 0.95;
        double g2 = 0.8;
        double maxP = 1.0;
        double minPercentage = 0.7;
        Double minThreshold = new Double(0.7 * (double)capacity);
        int maxThreshold = capacity;
        int currentLoad = 0;
        if (numCandidatePackets > capacity) {
            numCandidatePackets = 0 * capacity;
        }
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        int packetsOverflow = totalRequest - capacity;
        if ((double)totalRequest > 0.7 * (double)capacity) {
            Double overflow;
            Double NumPackets1;
            Double packetsOverflow1 = new Double((double)totalRequest - 0.7 * (double)capacity);
            packetsOverflow = packetsOverflow1.intValue();
            int[] redPackets = new int[packetsOverflow];
            int i2 = 0;
            while (i2 < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    NumPackets1 = new Double(requestArray[k]);
                    overflow = new Double(totalRequest - i2);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                k3 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k3 < support[j]) {
                        redPackets[i2] = j;
                        int n = j;
                        requestArray[n] = requestArray[n] - 1;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            currentLoad = minThreshold.intValue() + 1;
            int l = 0;
            while (l < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    NumPackets1 = new Double(requestArray[k]);
                    overflow = new Double(currentLoad);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                int m = 0;
                while (m < numCandidatePackets) {
                    k3 = Math.random();
                    int j = 0;
                    while (j < nFlows) {
                        if (k3 < support[j]) {
                            candidatePacket[m] = j;
                            break;
                        }
                        ++j;
                    }
                    ++m;
                }
                m = 0;
                while (m < numCandidatePackets) {
                    if (redPackets[l] == candidatePacket[m]) {
                        ++matches;
                    }
                    ++m;
                }
                if ((double)matches > g1 * (double)numCandidatePackets) {
                    requestArray[redPackets[l]] = requestArray[redPackets[l]] - matches;
                } else {
                    Double currentP = new Double(1.0 * (double)(currentLoad - minThreshold.intValue()) / (double)(maxThreshold - minThreshold.intValue()));
                    k3 = Math.random();
                    if (k3 > currentP) {
                        ++currentLoad;
                        int n = redPackets[l];
                        requestArray[n] = requestArray[n] + 1;
                    } else if (g1 * (double)numCandidatePackets >= (double)matches && (double)matches >= g2 * (double)numCandidatePackets) {
                        int n = redPackets[l];
                        requestArray[n] = requestArray[n] - matches;
                    }
                }
                matches = 0;
                ++l;
            }
        }
        i = 0;
        while (i < nFlows) {
            acceptArray[i] = requestArray[i];
            ++i;
        }
    }
}

