/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class CHOKeQueuePolicy
extends QueuePolicy {
    public CHOKeQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int packetsOverflow = 0;
        int Candidate1 = -1;
        double maxP = 1.0;
        double minPercentage = 0.7;
        Double minThreshold = new Double(0.7 * (double)capacity);
        int maxThreshold = capacity;
        int currentLoad = 0;
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        if ((double)totalRequest > 0.7 * (double)capacity) {
            double k1;
            Double overflow;
            Double NumPackets1;
            Double packetsOverflow1 = new Double((double)totalRequest - 0.7 * (double)capacity);
            packetsOverflow = packetsOverflow1.intValue();
            int[] redPackets = new int[packetsOverflow];
            int i2 = 0;
            while (i2 < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    NumPackets1 = new Double(requestArray[k]);
                    overflow = new Double(totalRequest - i2);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                k1 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k1 < support[j]) {
                        redPackets[i2] = j;
                        int n = j;
                        requestArray[n] = requestArray[n] - 1;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            currentLoad = minThreshold.intValue() + 1;
            int l = 0;
            while (l < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    NumPackets1 = new Double(requestArray[k]);
                    overflow = new Double(currentLoad);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                k1 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k1 < support[j]) {
                        Candidate1 = j;
                        break;
                    }
                    ++j;
                }
                if (Candidate1 == redPackets[l]) {
                    requestArray[Candidate1] = requestArray[Candidate1] - 1;
                    requestArray[Candidate1] = Math.max(0, requestArray[Candidate1]);
                } else {
                    Double currentP = new Double(1.0 * (double)(currentLoad - minThreshold.intValue()) / (double)(maxThreshold - minThreshold.intValue()));
                    k1 = Math.random();
                    if (k1 > currentP) {
                        ++currentLoad;
                        int n = redPackets[l];
                        requestArray[n] = requestArray[n] + 1;
                    }
                }
                ++l;
            }
        }
        i = 0;
        while (i < nFlows) {
            acceptArray[i] = requestArray[i];
            ++i;
        }
    }
}

