/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class DropTailQueuePolicy
extends QueuePolicy {
    public DropTailQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        if (totalRequest > capacity) {
            int packetsOverflow = totalRequest - capacity;
            int l = 0;
            while (l < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    Double NumPackets1 = new Double(requestArray[k]);
                    Double overflow = new Double(totalRequest);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                double k1 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k1 < support[j]) {
                        int n = j;
                        requestArray[n] = requestArray[n] - 1;
                        --totalRequest;
                        acceptArray[j] = Math.max(0, requestArray[j]);
                        break;
                    }
                    ++j;
                }
                ++l;
            }
        }
    }
}

