/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class PrinceGQueuePolicy
extends QueuePolicy {
    public PrinceGQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        double k1;
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        int packetsOverflow = totalRequest - capacity;
        if ((double)totalRequest > 0.7 * (double)capacity && totalRequest <= capacity) {
            int max = 0;
            int maxPosition = -1;
            k1 = Math.random();
            int j = 0;
            while (j < nFlows) {
                double k2;
                if (requestArray[j] > max) {
                    maxPosition = j;
                    max = requestArray[j];
                } else if (requestArray[j] == max && (k2 = Math.random()) > k1) {
                    maxPosition = j;
                    max = requestArray[j];
                    k1 = k2;
                }
                ++j;
            }
            Double p = new Double(0.1 * (double)requestArray[maxPosition] * ((double)totalRequest - 0.7 * (double)capacity) / (0.30000000000000004 * (double)capacity) + 1.0);
            acceptArray[maxPosition] = requestArray[maxPosition] - p.intValue();
            acceptArray[maxPosition] = Math.max(0, acceptArray[maxPosition]);
        } else if (totalRequest > capacity) {
            int l = 0;
            while (l < packetsOverflow) {
                int k = 0;
                while (k < nFlows) {
                    Double NumPackets1 = new Double(requestArray[k]);
                    Double overflow = new Double(totalRequest);
                    support[k] = NumPackets1 / overflow;
                    ++k;
                }
                k = 1;
                while (k < nFlows) {
                    support[k] = support[k] + support[k - 1];
                    ++k;
                }
                k1 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k1 < support[j]) {
                        int n = j;
                        requestArray[n] = requestArray[n] - 1;
                        --totalRequest;
                        acceptArray[j] = Math.max(0, requestArray[j]);
                        break;
                    }
                    ++j;
                }
                ++l;
            }
        }
        i = 0;
        while (i < nFlows) {
            ++i;
        }
    }
}

