/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class PrinceMQueuePolicy
extends QueuePolicy {
    public PrinceMQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int packetsOverflow = 0;
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        packetsOverflow = totalRequest - capacity;
        int max = 0;
        int maxPosition = -1;
        double k1 = Math.random();
        int j = 0;
        while (j < nFlows) {
            double k2;
            if (requestArray[j] > max) {
                maxPosition = j;
                max = requestArray[j];
            } else if (requestArray[j] == max && (k2 = Math.random()) > k1) {
                maxPosition = j;
                max = requestArray[j];
                k1 = k2;
            }
            ++j;
        }
        if ((double)totalRequest > 0.7 * (double)capacity && totalRequest <= capacity) {
            Double p = new Double(0.1 * (double)requestArray[maxPosition] * ((double)totalRequest - 0.7 * (double)capacity) / (0.30000000000000004 * (double)capacity) + 1.0);
            acceptArray[maxPosition] = requestArray[maxPosition] - p.intValue();
            acceptArray[maxPosition] = Math.max(0, acceptArray[maxPosition]);
        } else if (totalRequest > capacity) {
            if (acceptArray[maxPosition] > packetsOverflow) {
                int n = maxPosition;
                acceptArray[n] = acceptArray[n] - packetsOverflow;
            } else {
                acceptArray[maxPosition] = 0;
                packetsOverflow -= requestArray[maxPosition];
                totalRequest -= requestArray[maxPosition];
                requestArray[maxPosition] = 0;
                int l = 0;
                while (l < packetsOverflow) {
                    int k = 0;
                    while (k < nFlows) {
                        Double NumPackets1 = new Double(requestArray[k]);
                        Double overflow = new Double(totalRequest);
                        support[k] = NumPackets1 / overflow;
                        ++k;
                    }
                    k = 1;
                    while (k < nFlows) {
                        support[k] = support[k] + support[k - 1];
                        ++k;
                    }
                    k1 = Math.random();
                    int j2 = 0;
                    while (j2 < nFlows) {
                        if (k1 < support[j2]) {
                            int n = j2;
                            requestArray[n] = requestArray[n] - 1;
                            --totalRequest;
                            acceptArray[j2] = requestArray[j2];
                            break;
                        }
                        ++j2;
                    }
                    ++l;
                }
            }
            int i2 = 0;
            while (i2 < nFlows) {
                ++i2;
            }
        }
    }
}

