/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.queuepolicy;

import netknack.light.QueuePolicyAPI;
import netknack.light.queuepolicy.QueuePolicy;

public class REDQueuePolicy
extends QueuePolicy {
    public REDQueuePolicy(QueuePolicyAPI queuePolicyAPI) {
        super(queuePolicyAPI);
    }

    @Override
    public void playRound() {
        int capacity = this.queuePolicyAPI.getRoundCapacity();
        int nFlows = this.queuePolicyAPI.getNumOfFlows();
        int[] requestArray = new int[nFlows];
        int[] acceptArray = this.queuePolicyAPI.getAcceptArray();
        double[] support = new double[nFlows];
        int totalRequest = 0;
        int packetsOverflow = 0;
        int currentLoad = 0;
        double maxP = 1.0;
        double minPercentage = 0.7;
        Double minThreshold = new Double(0.7 * (double)capacity);
        int maxThreshold = capacity;
        int i = 0;
        while (i < nFlows) {
            requestArray[i] = this.queuePolicyAPI.getRequestArray()[i];
            acceptArray[i] = requestArray[i];
            totalRequest += requestArray[i];
            ++i;
        }
        if ((double)totalRequest > 0.7 * (double)capacity) {
            double k1;
            Double packetsOverflow1 = new Double((double)totalRequest - 0.7 * (double)capacity);
            packetsOverflow = packetsOverflow1.intValue();
            int[] redPackets = new int[packetsOverflow];
            int k = 0;
            while (k < nFlows) {
                Double NumPackets1 = new Double(requestArray[k]);
                Double overflow = new Double(totalRequest);
                support[k] = NumPackets1 / overflow;
                ++k;
            }
            k = 1;
            while (k < nFlows) {
                support[k] = support[k] + support[k - 1];
                ++k;
            }
            k = 0;
            while (k < packetsOverflow) {
                k1 = Math.random();
                int j = 0;
                while (j < nFlows) {
                    if (k1 < support[j]) {
                        redPackets[k] = j;
                        break;
                    }
                    ++j;
                }
                ++k;
            }
            currentLoad = minThreshold.intValue() + 1;
            k = 0;
            while (k < packetsOverflow) {
                Double currentP = new Double(1.0 * (double)(currentLoad - minThreshold.intValue()) / (double)(maxThreshold - minThreshold.intValue()));
                k1 = Math.random();
                if (k1 > currentP) {
                    ++currentLoad;
                } else {
                    int n = redPackets[k];
                    acceptArray[n] = acceptArray[n] - 1;
                }
                ++k;
            }
        }
        i = 0;
        while (i < nFlows) {
            ++i;
        }
    }
}

