/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.stats;

import netknack.light.Finals;

public class ConfidenceIntervalCalculator {
    public final int size;
    public final int[] sample;
    public double mean;
    public double stdDev;
    public double confInt;

    public ConfidenceIntervalCalculator(int parSize) {
        this.size = parSize;
        this.sample = new int[this.size];
        this.mean = Double.NaN;
        this.stdDev = Double.NaN;
        this.confInt = Double.NaN;
    }

    public double getConfidenceInterval() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size) {
            sum += (double)this.sample[i];
            ++i;
        }
        this.mean = sum / (double)this.size;
        sum = 0.0;
        i = 0;
        while (i < this.size) {
            sum += ((double)this.sample[i] - this.mean) * ((double)this.sample[i] - this.mean);
            ++i;
        }
        this.stdDev = Math.sqrt(sum /= (double)this.size);
        this.confInt = Finals.confidenceFactor * this.stdDev;
        return this.confInt;
    }
}

