/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.stats;

import netknack.light.stats.ConfidenceIntervalCalculator;
import netknack.utils.MyRound;

public class FlowStats {
    public int blendNum;
    public int flowID;
    public int a;
    public double b;
    public int initialWindowSize;
    public int totalRequestedPackets;
    public int totalAcceptedPackets;
    public double confIntTotalAcceptedPackets = Double.NaN;

    public String toString() {
        String str = null;
        str = String.valueOf(this.flowID + 1) + " " + this.a + " " + this.b + " " + this.totalRequestedPackets + " " + this.totalAcceptedPackets;
        return str;
    }

    public String toStringDeviator() {
        String str = null;
        str = String.valueOf(this.flowID + 1) + " " + this.a + " " + this.b + " " + this.totalRequestedPackets + " " + this.totalAcceptedPackets + " " + MyRound.myRound(this.confIntTotalAcceptedPackets, 2);
        return str;
    }

    public static FlowStats[] generateBlendedFlowStats(FlowStats[][] flowStats) {
        int blendNum = flowStats.length;
        int nFlows = flowStats[0].length;
        FlowStats[] blendedFlowStats = new FlowStats[nFlows];
        ConfidenceIntervalCalculator cic = null;
        int flow = 0;
        while (flow < nFlows) {
            boolean bDeviatorFlow = flow == nFlows - 1;
            blendedFlowStats[flow] = new FlowStats();
            blendedFlowStats[flow].blendNum = blendNum;
            blendedFlowStats[flow].flowID = flowStats[0][flow].flowID;
            blendedFlowStats[flow].a = flowStats[0][flow].a;
            blendedFlowStats[flow].b = flowStats[0][flow].b;
            int sumInitialWindowSize = 0;
            int sumTotalRequestedPackets = 0;
            int sumTotalAcceptedPackets = 0;
            int iteration = 0;
            while (iteration < blendNum) {
                sumInitialWindowSize += flowStats[iteration][flow].initialWindowSize;
                sumTotalRequestedPackets += flowStats[iteration][flow].totalRequestedPackets;
                sumTotalAcceptedPackets += flowStats[iteration][flow].totalAcceptedPackets;
                ++iteration;
            }
            blendedFlowStats[flow].initialWindowSize = sumInitialWindowSize / blendNum;
            blendedFlowStats[flow].totalRequestedPackets = sumTotalRequestedPackets / blendNum;
            blendedFlowStats[flow].totalAcceptedPackets = sumTotalAcceptedPackets / blendNum;
            if (bDeviatorFlow) {
                cic = new ConfidenceIntervalCalculator(blendNum);
                iteration = 0;
                while (iteration < blendNum) {
                    cic.sample[iteration] = flowStats[iteration][flow].totalAcceptedPackets;
                    ++iteration;
                }
                blendedFlowStats[flow].confIntTotalAcceptedPackets = cic.getConfidenceInterval();
            }
            ++flow;
        }
        return blendedFlowStats;
    }
}

