/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.stats;

import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.stats.FlowStats;
import netknack.light.stats.RouterStats;

public class GameStats {
    public int blendNum;
    public int gameID;
    public int rounds;
    public int nFlows;
    public int capacity;
    public int totalCapacityInAllRounds;
    public EnumFlowController flowPolicyType;
    public EnumFlowPenalty penalty;
    public RouterStats routerStats;
    public FlowStats[] flowStats;
    public int[] goodput;

    public String toString() {
        String str = null;
        str = String.valueOf(this.gameID) + " " + this.blendNum + " " + this.rounds + " " + this.nFlows + " " + this.capacity + " " + this.totalCapacityInAllRounds + " " + this.routerStats.toString() + " " + this.flowPolicyType.name() + " " + this.penalty.name();
        int i = 0;
        while (i < this.nFlows) {
            str = i == this.nFlows - 1 ? String.valueOf(str) + " " + this.flowStats[i].toStringDeviator() : String.valueOf(str) + " " + this.flowStats[i].toString();
            ++i;
        }
        return str;
    }

    public static GameStats generateBlendedGameStats(GameStats[] gameStats) {
        int blendNum;
        GameStats blendedStats = new GameStats();
        blendedStats.blendNum = blendNum = gameStats.length;
        RouterStats[] routerStats = new RouterStats[blendNum];
        int i = 0;
        while (i < blendNum) {
            routerStats[i] = gameStats[i].routerStats;
            ++i;
        }
        blendedStats.routerStats = RouterStats.generateBlendedRouterStats(routerStats);
        FlowStats[][] flowStats = new FlowStats[blendNum][];
        int i2 = 0;
        while (i2 < blendNum) {
            flowStats[i2] = gameStats[i2].flowStats;
            ++i2;
        }
        blendedStats.flowStats = FlowStats.generateBlendedFlowStats(flowStats);
        blendedStats.gameID = gameStats[0].gameID;
        blendedStats.rounds = gameStats[0].rounds;
        blendedStats.nFlows = gameStats[0].nFlows;
        blendedStats.flowPolicyType = gameStats[0].flowPolicyType;
        blendedStats.penalty = gameStats[0].penalty;
        blendedStats.goodput = new int[blendedStats.nFlows];
        blendedStats.capacity = gameStats[0].capacity;
        int sumTotalCapacityInAllRounds = 0;
        int iteration = 0;
        while (iteration < blendNum) {
            sumTotalCapacityInAllRounds += gameStats[iteration].totalCapacityInAllRounds;
            ++iteration;
        }
        blendedStats.totalCapacityInAllRounds = sumTotalCapacityInAllRounds / blendNum;
        return blendedStats;
    }

    public int getGoodput(int flowNum) {
        int i = 0;
        while (i < this.nFlows) {
            this.goodput[i] = this.flowStats[i].totalAcceptedPackets;
            ++i;
        }
        return this.goodput[flowNum];
    }
}

