/*
 * Decompiled with CFR 0.152.
 */
package netknack.light.symmetricNE;

import java.io.PrintStream;
import netknack.light.BlendedWindowGame;
import netknack.light.EnumExperimentType;
import netknack.light.EnumFlowController;
import netknack.light.EnumFlowPenalty;
import netknack.light.EnumGameType;
import netknack.light.EnumQueuePolicy;
import netknack.light.Finals;
import netknack.light.GameParams;
import netknack.light.Logger;
import netknack.light.NetKnackUI;
import netknack.light.WindowGame;

public class SymmetricNE {
    public NetKnackUI nkUI;
    public Logger logger;
    EnumExperimentType experimentType;
    int blendNum;
    int gameID;
    int pregameRounds;
    int duration;
    GameParams gameParams;
    PrintStream logpst;
    int[] goodput;

    public SymmetricNE(NetKnackUI netKnackUI, String[] args) {
        this.nkUI = netKnackUI;
        this.nkUI.logLine("Creating experiment with NetKnack v" + Finals.version);
        this.gameParams = new GameParams();
        this.gameParams.gameType = EnumGameType.parseGameType(args[0]);
        this.experimentType = EnumExperimentType.parseExperimentType(args[1]);
        this.blendNum = Integer.parseInt(args[2]);
        this.gameParams.gameID = Integer.parseInt(args[3]);
        this.gameParams.duration = Integer.parseInt(args[4]);
        this.gameParams.pregameRounds = Integer.parseInt(args[5]);
        this.gameParams.capacity = Integer.parseInt(args[6]);
        this.gameParams.variableCapacity = Integer.parseInt(args[7]);
        this.gameParams.penalty = EnumFlowPenalty.parseFlowPenalty(args[8]);
        this.gameParams.queuePolicyType = EnumQueuePolicy.parseQueuePolicy(args[9]);
        this.gameParams.nFlows = Integer.parseInt(args[10]);
        this.gameParams.flowPolicyType = EnumFlowController.parseFlowController(args[11]);
        this.gameParams.SetArrays(this.gameParams.nFlows);
        int i = 0;
        while (i < this.gameParams.nFlows - 1) {
            this.gameParams.aArray[i] = Integer.parseInt(args[12]);
            this.gameParams.bArray[i] = Double.parseDouble(args[13]);
            ++i;
        }
        this.gameParams.aArray[this.gameParams.nFlows - 1] = Integer.parseInt(args[14]);
        this.gameParams.bArray[this.gameParams.nFlows - 1] = Double.parseDouble(args[15]);
        this.gameParams.seed = Long.parseLong(args[16]);
        this.logger = new Logger(this.nkUI, this.gameParams);
    }

    public void playOneGame() {
        WindowGame wg = new WindowGame(this.gameParams, this.logger);
        wg.playAllRounds();
        this.logger.logLine(wg.getGameStats().toString());
    }

    public void playOneBlendedGame(int blendNum) {
        BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, this.gameParams);
        bwg.playAllRounds();
        this.logger.logLine(bwg.getGameStats().toString());
    }

    public void playGamesForAllA() {
        int minA = 1;
        int maxA = this.gameParams.capacity;
        int a = minA;
        while (a <= maxA) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a++;
            WindowGame wg = new WindowGame(this.gameParams, this.logger);
            wg.playAllRounds();
            this.logger.logLine(wg.getGameStats().toString());
        }
    }

    public void playBlendedGamesForAllA(int blendNum) {
        int minA = 1;
        int maxA = 50;
        this.goodput = new int[maxA];
        int a = minA;
        while (a <= maxA) {
            GameParams oneGame = this.gameParams.clone();
            oneGame.gameID = this.gameParams.gameID + a;
            oneGame.aArray[oneGame.nFlows - 1] = a;
            BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, oneGame);
            bwg.playAllRounds();
            this.goodput[a - 1] = bwg.getGameStats().getGoodput(this.gameParams.nFlows - 1);
            this.logger.logLine(bwg.getGameStats().toString());
            ++a;
        }
        this.logger.logLine("bestA=" + this.bestA(maxA));
    }

    public void playBlendedGamesForAllB(int blendNum) {
        int minB = 50;
        int maxB = 99;
        this.goodput = new int[maxB - minB + 1];
        int i = minB;
        while (i <= maxB) {
            GameParams oneGame = this.gameParams.clone();
            ++this.gameParams.gameID;
            oneGame.gameID = oneGame.gameID;
            Double b = new Double(0.01 * (double)i);
            oneGame.bArray[oneGame.nFlows - 1] = b;
            BlendedWindowGame bwg = new BlendedWindowGame(this.logger, blendNum, oneGame);
            bwg.playAllRounds();
            this.goodput[i - minB] = bwg.getGameStats().getGoodput(this.gameParams.nFlows - 1);
            this.logger.logLine(bwg.getGameStats().toString());
            ++i;
        }
        this.logger.logLine("bestB=" + this.bestB(minB, maxB));
    }

    public int bestA(int maxA) {
        int bestA = 0;
        int maxGoodput = 0;
        int a = 0;
        while (a < maxA) {
            if ((double)this.goodput[a] > 1.02 * (double)maxGoodput) {
                bestA = a + 1;
                maxGoodput = this.goodput[a];
            }
            ++a;
        }
        return bestA;
    }

    public double bestB(double minB, double maxB) {
        double bestB = 0.5;
        int maxGoodput = 0;
        int a = 0;
        while ((double)a < maxB - minB + 1.0) {
            if ((double)this.goodput[a] > 1.02 * (double)maxGoodput) {
                bestB = (minB + (double)a) * 0.01;
                maxGoodput = this.goodput[a];
            }
            ++a;
        }
        return bestB;
    }

    public void execute() {
        this.logger.logLine("Starting experiment ...");
        switch (this.experimentType) {
            case GAME: {
                this.playOneGame();
                break;
            }
            case BGAME: {
                this.playOneBlendedGame(this.blendNum);
                break;
            }
            case BGAME_ALL_A: {
                this.playBlendedGamesForAllA(this.blendNum);
                break;
            }
            case BGAME_ALL_B: {
                this.playBlendedGamesForAllB(this.blendNum);
                break;
            }
            default: {
                System.err.println("Unexpected SymmetricNE game type! Type must be one of {GAME, BGAME, BGAME_ALL_A, BGAME_ALL_B}");
            }
        }
        this.logger.logLine("SymmetricNE terminated !");
    }
}

